/*
Copyright 2005, 2006, 2007 Dennis van Weeren

This file is part of Minimig

Minimig is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

Minimig is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

This is the Minimig OSD Font Only to make it separate .
		
-- Goran Ljubojevic --
2009-11-14	- Created from osd.c
			- Fixed vertical position by shifting all chars for 1 bit right
2009-12-05	- Font reduced to 7bit ASCII to fit in rom
2009-12-25	- Added constants for font definition
2010-08-26	- Added firmwareConfiguration.h
*/

#include "firmwareConfiguration.h"
#include "osdFont.h"

// character font
// Reduced to 7bit ASCII to fit in rom
//*******************************************
// CCS Formatted Character Font
// Vertical Character Format
//*******************************************
const unsigned char charfont[OSD_FONT_CHAR_NUMBER][OSD_FONT_CHAR_WIDTH]=
{
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 0 	[0x0]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 1 	[0x1]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 2 	[0x2]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 3 	[0x3]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 4 	[0x4]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 5 	[0x5]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 6 	[0x6]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 7 	[0x7]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 8 	[0x8]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 9 	[0x9]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 10 	[0xa]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 11 	[0xb]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 12 	[0xc]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 13 	[0xd]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 14 	[0xe]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 15 	[0xf]
	0x00>>1,0xfe>>1,0x7c>>1,0x38>>1,0x10>>1,		// 16 	[0x10]
	0x10>>1,0x38>>1,0x7c>>1,0xfe>>1,0x00>>1,		// 17 	[0x11]
	0x0c>>1,0x0a>>1,0x00>>1,0x0c>>1,0x0a>>1,		// 18 	[0x12]
	0x0a>>1,0x06>>1,0x00>>1,0x0a>>1,0x06>>1,		// 19 	[0x13]
	0x88>>1,0xcc>>1,0xee>>1,0xcc>>1,0x88>>1,		// 20 	[0x14]
	0x22>>1,0x66>>1,0xee>>1,0x66>>1,0x22>>1,		// 21 	[0x15]
	0x38>>1,0x7c>>1,0x7c>>1,0x7c>>1,0x38>>1,		// 22 	[0x16]
	0x20>>1,0x70>>1,0xa8>>1,0x20>>1,0x3e>>1,		// 23 	[0x17]
	0x08>>1,0x04>>1,0xfe>>1,0x04>>1,0x08>>1,		// 24 	[0x18]
	0x20>>1,0x40>>1,0xfe>>1,0x40>>1,0x20>>1,		// 25 	[0x19]
	0x10>>1,0x10>>1,0x54>>1,0x38>>1,0x10>>1,		// 26 	[0x1a]
	0x10>>1,0x38>>1,0x54>>1,0x10>>1,0x10>>1,		// 27 	[0x1b]
	0x80>>1,0x88>>1,0x94>>1,0xa2>>1,0x80>>1,		// 28 	[0x1c]
	0x80>>1,0xa2>>1,0x94>>1,0x88>>1,0x80>>1,		// 29 	[0x1d]
	0x40>>1,0x70>>1,0x7c>>1,0x70>>1,0x40>>1,		// 30 	[0x1e]
	0x04>>1,0x1c>>1,0x7c>>1,0x1c>>1,0x04>>1,		// 31 	[0x1f]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 32 	[0x20]
	0x00>>1,0x00>>1,0xbe>>1,0x00>>1,0x00>>1,		// 33 	[0x21]
	0x00>>1,0x0e>>1,0x00>>1,0x0e>>1,0x00>>1,		// 34 	[0x22]
	0x28>>1,0xfe>>1,0x28>>1,0xfe>>1,0x28>>1,		// 35 	[0x23]
	0x48>>1,0x54>>1,0xfe>>1,0x54>>1,0x24>>1,		// 36 	[0x24]
	0x46>>1,0x26>>1,0x10>>1,0xc8>>1,0xc4>>1,		// 37 	[0x25]
	0x6c>>1,0x92>>1,0xaa>>1,0x44>>1,0xa0>>1,		// 38 	[0x26]
	0x00>>1,0x00>>1,0x0a>>1,0x06>>1,0x00>>1,		// 39 	[0x27]
	0x00>>1,0x38>>1,0x44>>1,0x82>>1,0x00>>1,		// 40 	[0x28]
	0x00>>1,0x82>>1,0x44>>1,0x38>>1,0x00>>1,		// 41 	[0x29]
	0x28>>1,0x10>>1,0x7c>>1,0x10>>1,0x28>>1,		// 42 	[0x2a]
	0x10>>1,0x10>>1,0x7c>>1,0x10>>1,0x10>>1,		// 43 	[0x2b]
	0x00>>1,0xa0>>1,0x60>>1,0x00>>1,0x00>>1,		// 44 	[0x2c]
	0x10>>1,0x10>>1,0x10>>1,0x10>>1,0x10>>1,		// 45 	[0x2d]
	0x00>>1,0xc0>>1,0xc0>>1,0x00>>1,0x00>>1,		// 46 	[0x2e]
	0x40>>1,0x20>>1,0x10>>1,0x08>>1,0x04>>1,		// 47 	[0x2f]
	0x7c>>1,0xa2>>1,0x92>>1,0x8a>>1,0x7c>>1,		// 48 	[0x30]
	0x00>>1,0x84>>1,0xfe>>1,0x80>>1,0x00>>1,		// 49 	[0x31]
	0x84>>1,0xc2>>1,0xa2>>1,0x92>>1,0x8c>>1,		// 50 	[0x32]
	0x42>>1,0x82>>1,0x8a>>1,0x96>>1,0x62>>1,		// 51 	[0x33]
	0x30>>1,0x28>>1,0x24>>1,0xfe>>1,0x20>>1,		// 52 	[0x34]
	0x4e>>1,0x8a>>1,0x8a>>1,0x8a>>1,0x72>>1,		// 53 	[0x35]
	0x78>>1,0x94>>1,0x92>>1,0x92>>1,0x60>>1,		// 54 	[0x36]
	0x06>>1,0x02>>1,0xe2>>1,0x12>>1,0x0e>>1,		// 55 	[0x37]
	0x6c>>1,0x92>>1,0x92>>1,0x92>>1,0x6c>>1,		// 56 	[0x38]
	0x0c>>1,0x92>>1,0x92>>1,0x52>>1,0x3c>>1,		// 57 	[0x39]
	0x00>>1,0xcc>>1,0xcc>>1,0x00>>1,0x00>>1,		// 58 	[0x3a]
	0x00>>1,0xac>>1,0x6c>>1,0x00>>1,0x00>>1,		// 59 	[0x3b]
	0x10>>1,0x28>>1,0x44>>1,0x82>>1,0x00>>1,		// 60 	[0x3c]
	0x28>>1,0x28>>1,0x28>>1,0x28>>1,0x28>>1,		// 61 	[0x3d]
	0x00>>1,0x82>>1,0x44>>1,0x28>>1,0x10>>1,		// 62 	[0x3e]
	0x04>>1,0x02>>1,0xa2>>1,0x12>>1,0x0c>>1,		// 63 	[0x3f]
	0x64>>1,0x92>>1,0xf2>>1,0x82>>1,0x7c>>1,		// 64 	[0x40]
	0xf8>>1,0x24>>1,0x22>>1,0x24>>1,0xf8>>1,		// 65 	[0x41]
	0xfe>>1,0x92>>1,0x92>>1,0x92>>1,0x6c>>1,		// 66 	[0x42]
	0x7c>>1,0x82>>1,0x82>>1,0x82>>1,0x44>>1,		// 67 	[0x43]
	0xfe>>1,0x82>>1,0x82>>1,0x44>>1,0x38>>1,		// 68 	[0x44]
	0xfe>>1,0x92>>1,0x92>>1,0x92>>1,0x82>>1,		// 69 	[0x45]
	0xfe>>1,0x12>>1,0x12>>1,0x12>>1,0x02>>1,		// 70 	[0x46]
	0x7c>>1,0x82>>1,0x92>>1,0x92>>1,0xf4>>1,		// 71 	[0x47]
	0xfe>>1,0x10>>1,0x10>>1,0x10>>1,0xfe>>1,		// 72 	[0x48]
	0x00>>1,0x82>>1,0xfe>>1,0x82>>1,0x00>>1,		// 73 	[0x49]
	0x40>>1,0x80>>1,0x82>>1,0x7e>>1,0x02>>1,		// 74 	[0x4a]
	0xfe>>1,0x10>>1,0x28>>1,0x44>>1,0x82>>1,		// 75 	[0x4b]
	0xfe>>1,0x80>>1,0x80>>1,0x80>>1,0x80>>1,		// 76 	[0x4c]
	0xfe>>1,0x04>>1,0x18>>1,0x04>>1,0xfe>>1,		// 77 	[0x4d]
	0xfe>>1,0x08>>1,0x10>>1,0x20>>1,0xfe>>1,		// 78 	[0x4e]
	0x7c>>1,0x82>>1,0x82>>1,0x82>>1,0x7c>>1,		// 79 	[0x4f]
	0xfe>>1,0x12>>1,0x12>>1,0x12>>1,0x0c>>1,		// 80 	[0x50]
	0x7c>>1,0x82>>1,0xa2>>1,0x42>>1,0xbc>>1,		// 81 	[0x51]
	0xfe>>1,0x12>>1,0x32>>1,0x52>>1,0x8c>>1,		// 82 	[0x52]
	0x4c>>1,0x92>>1,0x92>>1,0x92>>1,0x64>>1,		// 83 	[0x53]
	0x02>>1,0x02>>1,0xfe>>1,0x02>>1,0x02>>1,		// 84 	[0x54]
	0x7e>>1,0x80>>1,0x80>>1,0x80>>1,0x7e>>1,		// 85 	[0x55]
	0x3e>>1,0x40>>1,0x80>>1,0x40>>1,0x3e>>1,		// 86 	[0x56]
	0xfe>>1,0x40>>1,0x30>>1,0x40>>1,0xfe>>1,		// 87 	[0x57]
	0xc6>>1,0x28>>1,0x10>>1,0x28>>1,0xc6>>1,		// 88 	[0x58]
	0x0e>>1,0x10>>1,0xe0>>1,0x10>>1,0x0e>>1,		// 89 	[0x59]
	0xc2>>1,0xa2>>1,0x92>>1,0x8a>>1,0x86>>1,		// 90 	[0x5a]
	0x00>>1,0xfe>>1,0x82>>1,0x82>>1,0x00>>1,		// 91 	[0x5b]
	0x04>>1,0x08>>1,0x10>>1,0x20>>1,0x40>>1,		// 92 	[0x5c]
	0x00>>1,0x82>>1,0x82>>1,0xfe>>1,0x00>>1,		// 93 	[0x5d]
	0x08>>1,0x04>>1,0x02>>1,0x04>>1,0x08>>1,		// 94 	[0x5e]
	0x80>>1,0x80>>1,0x80>>1,0x80>>1,0x80>>1,		// 95 	[0x5f]
	0x00>>1,0x02>>1,0x04>>1,0x08>>1,0x00>>1,		// 96 	[0x60]
	0x40>>1,0xa8>>1,0xa8>>1,0xa8>>1,0xf0>>1,		// 97 	[0x61]
	0xfe>>1,0x90>>1,0x88>>1,0x88>>1,0x70>>1,		// 98 	[0x62]
	0x70>>1,0x88>>1,0x88>>1,0x88>>1,0x40>>1,		// 99 	[0x63]
	0x70>>1,0x88>>1,0x88>>1,0x90>>1,0xfe>>1,		// 100 	[0x64]
	0x70>>1,0xa8>>1,0xa8>>1,0xa8>>1,0x30>>1,		// 101 	[0x65]
	0x10>>1,0xfc>>1,0x12>>1,0x02>>1,0x04>>1,		// 102 	[0x66]
	0x10>>1,0xa8>>1,0xa8>>1,0xa8>>1,0x78>>1,		// 103 	[0x67]
	0xfe>>1,0x10>>1,0x08>>1,0x08>>1,0xf0>>1,		// 104 	[0x68]
	0x00>>1,0x90>>1,0xfa>>1,0x80>>1,0x00>>1,		// 105 	[0x69]
	0x40>>1,0x80>>1,0x88>>1,0x7a>>1,0x00>>1,		// 106 	[0x6a]
	0x00>>1,0xfe>>1,0x20>>1,0x50>>1,0x88>>1,		// 107 	[0x6b]
	0x00>>1,0x82>>1,0xfe>>1,0x80>>1,0x00>>1,		// 108 	[0x6c]
	0xf8>>1,0x08>>1,0xf0>>1,0x08>>1,0xf8>>1,		// 109 	[0x6d]
	0xf8>>1,0x10>>1,0x08>>1,0x08>>1,0xf0>>1,		// 110 	[0x6e]
	0x70>>1,0x88>>1,0x88>>1,0x88>>1,0x70>>1,		// 111 	[0x6f]
	0xf8>>1,0x28>>1,0x28>>1,0x28>>1,0x10>>1,		// 112 	[0x70]
	0x08>>1,0x14>>1,0x14>>1,0x18>>1,0xfc>>1,		// 113 	[0x71]
	0xf8>>1,0x10>>1,0x08>>1,0x08>>1,0x10>>1,		// 114 	[0x72]
	0x90>>1,0xa8>>1,0xa8>>1,0xa8>>1,0x40>>1,		// 115 	[0x73]
	0x08>>1,0x7e>>1,0x88>>1,0x80>>1,0x40>>1,		// 116 	[0x74]
	0x78>>1,0x80>>1,0x80>>1,0x40>>1,0xf8>>1,		// 117 	[0x75]
	0x38>>1,0x40>>1,0x80>>1,0x40>>1,0x38>>1,		// 118 	[0x76]
	0x78>>1,0x80>>1,0x60>>1,0x80>>1,0x78>>1,		// 119 	[0x77]
	0x88>>1,0x50>>1,0x20>>1,0x50>>1,0x88>>1,		// 120 	[0x78]
	0x18>>1,0xa0>>1,0xa0>>1,0xa0>>1,0x78>>1,		// 121 	[0x79]
	0x88>>1,0xc8>>1,0xa8>>1,0x98>>1,0x88>>1,		// 122 	[0x7a]
	0x00>>1,0x10>>1,0x6c>>1,0x82>>1,0x00>>1,		// 123 	[0x7b]
	0x00>>1,0x00>>1,0xfe>>1,0x00>>1,0x00>>1,		// 124 	[0x7c]
	0x00>>1,0x82>>1,0x6c>>1,0x10>>1,0x00>>1,		// 125 	[0x7d]
	0x10>>1,0x08>>1,0x08>>1,0x10>>1,0x08>>1,		// 126 	[0x7e]
	0xf0>>1,0x88>>1,0x84>>1,0x88>>1,0xf0>>1			// 127 	[0x7f]
};




/*
// Old Character font full 256 characters
const unsigned char charfont[256][5]=
{
	0x00>>1,0xfe>>1,0x81>>1,0xfe>>1,0x00>>1,		// 0 	[0x0]
	0x00>>1,0xfe>>1,0xc1>>1,0xfe>>1,0x00>>1,		// 1 	[0x1]
	0x00>>1,0xfe>>1,0xe1>>1,0xfe>>1,0x00>>1,		// 2 	[0x2]
	0x00>>1,0xfe>>1,0xf1>>1,0xfe>>1,0x00>>1,		// 3 	[0x3]
	0x00>>1,0xfe>>1,0xf9>>1,0xfe>>1,0x00>>1,		// 4 	[0x4]
	0x00>>1,0xfe>>1,0xfd>>1,0xfe>>1,0x00>>1,		// 5 	[0x5]
	0x00>>1,0xfe>>1,0xff>>1,0xfe>>1,0x00>>1,		// 6 	[0x6]
	0x18>>1,0x1f>>1,0xc1>>1,0xf8>>1,0x08>>1,		// 7 	[0x7]
	0x18>>1,0x42>>1,0x3c>>1,0x81>>1,0x7e>>1,		// 8 	[0x8]
	0x32>>1,0x2a>>1,0xe7>>1,0x2a>>1,0x32>>1,		// 9 	[0x9]
	0xe2>>1,0x51>>1,0xe2>>1,0x64>>1,0x92>>1,		// 10 	[0xa]
	0xf5>>1,0x91>>1,0x65>>1,0x61>>1,0x95>>1,		// 11 	[0xb]
	0x5c>>1,0x62>>1,0x02>>1,0x62>>1,0x5c>>1,		// 12 	[0xc]
	0xfa>>1,0x00>>1,0xf0>>1,0x90>>1,0xfe>>1,		// 13 	[0xd]
	0x3e>>1,0x3e>>1,0x36>>1,0x3e>>1,0x3e>>1,		// 14 	[0xe]
	0x38>>1,0x44>>1,0x44>>1,0x28>>1,0x28>>1,		// 15 	[0xf]
	0x00>>1,0xfe>>1,0x7c>>1,0x38>>1,0x10>>1,		// 16 	[0x10]
	0x10>>1,0x38>>1,0x7c>>1,0xfe>>1,0x00>>1,		// 17 	[0x11]
	0x60>>1,0xff>>1,0xf9>>1,0xdf>>1,0x60>>1,		// 18 	[0x12]
	0x0c>>1,0x1f>>1,0xfc>>1,0x1f>>1,0x0c>>1,		// 19 	[0x13]
	0x88>>1,0xcc>>1,0xee>>1,0xcc>>1,0x88>>1,		// 20 	[0x14]
	0x22>>1,0x66>>1,0xee>>1,0x66>>1,0x22>>1,		// 21 	[0x15]
	0x38>>1,0x7c>>1,0x7c>>1,0x7c>>1,0x38>>1,		// 22 	[0x16]
	0x20>>1,0x70>>1,0xa8>>1,0x20>>1,0x3e>>1,		// 23 	[0x17]
	0x08>>1,0x04>>1,0xfe>>1,0x04>>1,0x08>>1,		// 24 	[0x18]
	0x20>>1,0x40>>1,0xfe>>1,0x40>>1,0x20>>1,		// 25 	[0x19]
	0x10>>1,0x10>>1,0x54>>1,0x38>>1,0x10>>1,		// 26 	[0x1a]
	0x10>>1,0x38>>1,0x54>>1,0x10>>1,0x10>>1,		// 27 	[0x1b]
	0x80>>1,0x88>>1,0x94>>1,0xa2>>1,0x80>>1,		// 28 	[0x1c]
	0x80>>1,0xa2>>1,0x94>>1,0x88>>1,0x80>>1,		// 29 	[0x1d]
	0x40>>1,0x70>>1,0x7c>>1,0x70>>1,0x40>>1,		// 30 	[0x1e]
	0x04>>1,0x1c>>1,0x7c>>1,0x1c>>1,0x04>>1,		// 31 	[0x1f]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 32 	[0x20]
	0x00>>1,0x00>>1,0xbe>>1,0x00>>1,0x00>>1,		// 33 	[0x21]
	0x00>>1,0x0e>>1,0x00>>1,0x0e>>1,0x00>>1,		// 34 	[0x22]
	0x28>>1,0xfe>>1,0x28>>1,0xfe>>1,0x28>>1,		// 35 	[0x23]
	0x48>>1,0x54>>1,0xfe>>1,0x54>>1,0x24>>1,		// 36 	[0x24]
	0x46>>1,0x26>>1,0x10>>1,0xc8>>1,0xc4>>1,		// 37 	[0x25]
	0x6c>>1,0x92>>1,0xaa>>1,0x44>>1,0xa0>>1,		// 38 	[0x26]
	0x00>>1,0x00>>1,0x0a>>1,0x06>>1,0x00>>1,		// 39 	[0x27]
	0x00>>1,0x38>>1,0x44>>1,0x82>>1,0x00>>1,		// 40 	[0x28]
	0x00>>1,0x82>>1,0x44>>1,0x38>>1,0x00>>1,		// 41 	[0x29]
	0x28>>1,0x10>>1,0x7c>>1,0x10>>1,0x28>>1,		// 42 	[0x2a]
	0x10>>1,0x10>>1,0x7c>>1,0x10>>1,0x10>>1,		// 43 	[0x2b]
	0x00>>1,0xa0>>1,0x60>>1,0x00>>1,0x00>>1,		// 44 	[0x2c]
	0x10>>1,0x10>>1,0x10>>1,0x10>>1,0x10>>1,		// 45 	[0x2d]
	0x00>>1,0xc0>>1,0xc0>>1,0x00>>1,0x00>>1,		// 46 	[0x2e]
	0x40>>1,0x20>>1,0x10>>1,0x08>>1,0x04>>1,		// 47 	[0x2f]
	0x7c>>1,0xa2>>1,0x92>>1,0x8a>>1,0x7c>>1,		// 48 	[0x30]
	0x00>>1,0x84>>1,0xfe>>1,0x80>>1,0x00>>1,		// 49 	[0x31]
	0x84>>1,0xc2>>1,0xa2>>1,0x92>>1,0x8c>>1,		// 50 	[0x32]
	0x42>>1,0x82>>1,0x8a>>1,0x96>>1,0x62>>1,		// 51 	[0x33]
	0x30>>1,0x28>>1,0x24>>1,0xfe>>1,0x20>>1,		// 52 	[0x34]
	0x4e>>1,0x8a>>1,0x8a>>1,0x8a>>1,0x72>>1,		// 53 	[0x35]
	0x78>>1,0x94>>1,0x92>>1,0x92>>1,0x60>>1,		// 54 	[0x36]
	0x06>>1,0x02>>1,0xe2>>1,0x12>>1,0x0e>>1,		// 55 	[0x37]
	0x6c>>1,0x92>>1,0x92>>1,0x92>>1,0x6c>>1,		// 56 	[0x38]
	0x0c>>1,0x92>>1,0x92>>1,0x52>>1,0x3c>>1,		// 57 	[0x39]
	0x00>>1,0xcc>>1,0xcc>>1,0x00>>1,0x00>>1,		// 58 	[0x3a]
	0x00>>1,0xac>>1,0x6c>>1,0x00>>1,0x00>>1,		// 59 	[0x3b]
	0x10>>1,0x28>>1,0x44>>1,0x82>>1,0x00>>1,		// 60 	[0x3c]
	0x28>>1,0x28>>1,0x28>>1,0x28>>1,0x28>>1,		// 61 	[0x3d]
	0x00>>1,0x82>>1,0x44>>1,0x28>>1,0x10>>1,		// 62 	[0x3e]
	0x04>>1,0x02>>1,0xa2>>1,0x12>>1,0x0c>>1,		// 63 	[0x3f]
	0x64>>1,0x92>>1,0xf2>>1,0x82>>1,0x7c>>1,		// 64 	[0x40]
	0xf8>>1,0x24>>1,0x22>>1,0x24>>1,0xf8>>1,		// 65 	[0x41]
	0xfe>>1,0x92>>1,0x92>>1,0x92>>1,0x6c>>1,		// 66 	[0x42]
	0x7c>>1,0x82>>1,0x82>>1,0x82>>1,0x44>>1,		// 67 	[0x43]
	0xfe>>1,0x82>>1,0x82>>1,0x44>>1,0x38>>1,		// 68 	[0x44]
	0xfe>>1,0x92>>1,0x92>>1,0x92>>1,0x82>>1,		// 69 	[0x45]
	0xfe>>1,0x12>>1,0x12>>1,0x12>>1,0x02>>1,		// 70 	[0x46]
	0x7c>>1,0x82>>1,0x92>>1,0x92>>1,0xf4>>1,		// 71 	[0x47]
	0xfe>>1,0x10>>1,0x10>>1,0x10>>1,0xfe>>1,		// 72 	[0x48]
	0x00>>1,0x82>>1,0xfe>>1,0x82>>1,0x00>>1,		// 73 	[0x49]
	0x40>>1,0x80>>1,0x82>>1,0x7e>>1,0x02>>1,		// 74 	[0x4a]
	0xfe>>1,0x10>>1,0x28>>1,0x44>>1,0x82>>1,		// 75 	[0x4b]
	0xfe>>1,0x80>>1,0x80>>1,0x80>>1,0x80>>1,		// 76 	[0x4c]
	0xfe>>1,0x04>>1,0x18>>1,0x04>>1,0xfe>>1,		// 77 	[0x4d]
	0xfe>>1,0x08>>1,0x10>>1,0x20>>1,0xfe>>1,		// 78 	[0x4e]
	0x7c>>1,0x82>>1,0x82>>1,0x82>>1,0x7c>>1,		// 79 	[0x4f]
	0xfe>>1,0x12>>1,0x12>>1,0x12>>1,0x0c>>1,		// 80 	[0x50]
	0x7c>>1,0x82>>1,0xa2>>1,0x42>>1,0xbc>>1,		// 81 	[0x51]
	0xfe>>1,0x12>>1,0x32>>1,0x52>>1,0x8c>>1,		// 82 	[0x52]
	0x4c>>1,0x92>>1,0x92>>1,0x92>>1,0x64>>1,		// 83 	[0x53]
	0x02>>1,0x02>>1,0xfe>>1,0x02>>1,0x02>>1,		// 84 	[0x54]
	0x7e>>1,0x80>>1,0x80>>1,0x80>>1,0x7e>>1,		// 85 	[0x55]
	0x3e>>1,0x40>>1,0x80>>1,0x40>>1,0x3e>>1,		// 86 	[0x56]
	0xfe>>1,0x40>>1,0x30>>1,0x40>>1,0xfe>>1,		// 87 	[0x57]
	0xc6>>1,0x28>>1,0x10>>1,0x28>>1,0xc6>>1,		// 88 	[0x58]
	0x0e>>1,0x10>>1,0xe0>>1,0x10>>1,0x0e>>1,		// 89 	[0x59]
	0xc2>>1,0xa2>>1,0x92>>1,0x8a>>1,0x86>>1,		// 90 	[0x5a]
	0x00>>1,0xfe>>1,0x82>>1,0x82>>1,0x00>>1,		// 91 	[0x5b]
	0x04>>1,0x08>>1,0x10>>1,0x20>>1,0x40>>1,		// 92 	[0x5c]
	0x00>>1,0x82>>1,0x82>>1,0xfe>>1,0x00>>1,		// 93 	[0x5d]
	0x08>>1,0x04>>1,0x02>>1,0x04>>1,0x08>>1,		// 94 	[0x5e]
	0x80>>1,0x80>>1,0x80>>1,0x80>>1,0x80>>1,		// 95 	[0x5f]
	0x00>>1,0x02>>1,0x04>>1,0x08>>1,0x00>>1,		// 96 	[0x60]
	0x40>>1,0xa8>>1,0xa8>>1,0xa8>>1,0xf0>>1,		// 97 	[0x61]
	0xfe>>1,0x90>>1,0x88>>1,0x88>>1,0x70>>1,		// 98 	[0x62]
	0x70>>1,0x88>>1,0x88>>1,0x88>>1,0x40>>1,		// 99 	[0x63]
	0x70>>1,0x88>>1,0x88>>1,0x90>>1,0xfe>>1,		// 100 	[0x64]
	0x70>>1,0xa8>>1,0xa8>>1,0xa8>>1,0x30>>1,		// 101 	[0x65]
	0x10>>1,0xfc>>1,0x12>>1,0x02>>1,0x04>>1,		// 102 	[0x66]
	0x10>>1,0xa8>>1,0xa8>>1,0xa8>>1,0x78>>1,		// 103 	[0x67]
	0xfe>>1,0x10>>1,0x08>>1,0x08>>1,0xf0>>1,		// 104 	[0x68]
	0x00>>1,0x90>>1,0xfa>>1,0x80>>1,0x00>>1,		// 105 	[0x69]
	0x40>>1,0x80>>1,0x88>>1,0x7a>>1,0x00>>1,		// 106 	[0x6a]
	0x00>>1,0xfe>>1,0x20>>1,0x50>>1,0x88>>1,		// 107 	[0x6b]
	0x00>>1,0x82>>1,0xfe>>1,0x80>>1,0x00>>1,		// 108 	[0x6c]
	0xf8>>1,0x08>>1,0xf0>>1,0x08>>1,0xf8>>1,		// 109 	[0x6d]
	0xf8>>1,0x10>>1,0x08>>1,0x08>>1,0xf0>>1,		// 110 	[0x6e]
	0x70>>1,0x88>>1,0x88>>1,0x88>>1,0x70>>1,		// 111 	[0x6f]
	0xf8>>1,0x28>>1,0x28>>1,0x28>>1,0x10>>1,		// 112 	[0x70]
	0x08>>1,0x14>>1,0x14>>1,0x18>>1,0xfc>>1,		// 113 	[0x71]
	0xf8>>1,0x10>>1,0x08>>1,0x08>>1,0x10>>1,		// 114 	[0x72]
	0x90>>1,0xa8>>1,0xa8>>1,0xa8>>1,0x40>>1,		// 115 	[0x73]
	0x08>>1,0x7e>>1,0x88>>1,0x80>>1,0x40>>1,		// 116 	[0x74]
	0x78>>1,0x80>>1,0x80>>1,0x40>>1,0xf8>>1,		// 117 	[0x75]
	0x38>>1,0x40>>1,0x80>>1,0x40>>1,0x38>>1,		// 118 	[0x76]
	0x78>>1,0x80>>1,0x60>>1,0x80>>1,0x78>>1,		// 119 	[0x77]
	0x88>>1,0x50>>1,0x20>>1,0x50>>1,0x88>>1,		// 120 	[0x78]
	0x18>>1,0xa0>>1,0xa0>>1,0xa0>>1,0x78>>1,		// 121 	[0x79]
	0x88>>1,0xc8>>1,0xa8>>1,0x98>>1,0x88>>1,		// 122 	[0x7a]
	0x00>>1,0x10>>1,0x6c>>1,0x82>>1,0x00>>1,		// 123 	[0x7b]
	0x00>>1,0x00>>1,0xfe>>1,0x00>>1,0x00>>1,		// 124 	[0x7c]
	0x00>>1,0x82>>1,0x6c>>1,0x10>>1,0x00>>1,		// 125 	[0x7d]
	0x04>>1,0x02>>1,0x04>>1,0x08>>1,0x04>>1,		// 126 	[0x7e]
	0xf0>>1,0x88>>1,0x84>>1,0x88>>1,0xf0>>1,		// 127 	[0x7f]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 128 	[0x80]
	0xfe>>1,0xff>>1,0x33>>1,0xff>>1,0xfe>>1,		// 129 	[0x81]
	0xff>>1,0xff>>1,0xdb>>1,0xff>>1,0x76>>1,		// 130 	[0x82]
	0x7e>>1,0xff>>1,0xc3>>1,0xc3>>1,0xc3>>1,		// 131 	[0x83]
	0xff>>1,0xff>>1,0xc3>>1,0xff>>1,0x7e>>1,		// 132 	[0x84]
	0xff>>1,0xff>>1,0xdb>>1,0xdb>>1,0xc3>>1,		// 133 	[0x85]
	0xff>>1,0xff>>1,0x1b>>1,0x1b>>1,0x03>>1,		// 134 	[0x86]
	0x7e>>1,0xff>>1,0xd3>>1,0xf7>>1,0x76>>1,		// 135 	[0x87]
	0xff>>1,0xff>>1,0x18>>1,0xff>>1,0xff>>1,		// 136 	[0x88]
	0x00>>1,0xff>>1,0xff>>1,0xff>>1,0x00>>1,		// 137 	[0x89]
	0x60>>1,0xe0>>1,0xc0>>1,0xff>>1,0x7f>>1,		// 138 	[0x8a]
	0xff>>1,0xff>>1,0x3c>>1,0xf7>>1,0xe3>>1,		// 139 	[0x8b]
	0xff>>1,0xff>>1,0xc0>>1,0xc0>>1,0xc0>>1,		// 140 	[0x8c]
	0xff>>1,0x07>>1,0x1c>>1,0x07>>1,0xff>>1,		// 141 	[0x8d]
	0xff>>1,0x3f>>1,0x7e>>1,0xfc>>1,0xff>>1,		// 142 	[0x8e]
	0x7e>>1,0xff>>1,0xc3>>1,0xff>>1,0x7e>>1,		// 143 	[0x8f]
	0xff>>1,0xff>>1,0x33>>1,0x3f>>1,0x1e>>1,		// 144 	[0x90]
	0x7e>>1,0xff>>1,0xe3>>1,0x7f>>1,0xbe>>1,		// 145 	[0x91]
	0xff>>1,0xff>>1,0x3b>>1,0xef>>1,0xc6>>1,		// 146 	[0x92]
	0xce>>1,0xdf>>1,0xdb>>1,0xfb>>1,0x73>>1,		// 147 	[0x93]
	0x03>>1,0xff>>1,0xff>>1,0xff>>1,0x03>>1,		// 148 	[0x94]
	0x7f>>1,0xff>>1,0xc0>>1,0xff>>1,0x7f>>1,		// 149 	[0x95]
	0x3f>>1,0x7f>>1,0xe0>>1,0x7f>>1,0x3f>>1,		// 150 	[0x96]
	0xff>>1,0xe0>>1,0x38>>1,0xe0>>1,0xff>>1,		// 151 	[0x97]
	0xc7>>1,0xff>>1,0x38>>1,0xff>>1,0xc7>>1,		// 152 	[0x98]
	0x0f>>1,0x1f>>1,0xf0>>1,0x1f>>1,0x0f>>1,		// 153 	[0x99]
	0xe3>>1,0xf3>>1,0xdb>>1,0xcf>>1,0xc7>>1,		// 154 	[0x9a]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 155 	[0x9b]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 156 	[0x9c]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 157 	[0x9d]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 158 	[0x9e]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 159 	[0x9f]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 160 	[0xa0]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 161 	[0xa1]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 162 	[0xa2]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 163 	[0xa3]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 164 	[0xa4]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 165 	[0xa5]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 166 	[0xa6]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 167 	[0xa7]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 168 	[0xa8]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 169 	[0xa9]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 170 	[0xaa]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 171 	[0xab]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 172 	[0xac]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 173 	[0xad]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 174 	[0xae]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 175 	[0xaf]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 176 	[0xb0]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 177 	[0xb1]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 178 	[0xb2]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 179 	[0xb3]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 180 	[0xb4]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 181 	[0xb5]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 182 	[0xb6]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 183 	[0xb7]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 184 	[0xb8]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 185 	[0xb9]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 186 	[0xba]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 187 	[0xbb]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 188 	[0xbc]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 189 	[0xbd]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 190 	[0xbe]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 191 	[0xbf]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 192 	[0xc0]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 193 	[0xc1]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 194 	[0xc2]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 195 	[0xc3]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 196 	[0xc4]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 197 	[0xc5]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 198 	[0xc6]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 199 	[0xc7]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 200 	[0xc8]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 201 	[0xc9]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 202 	[0xca]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 203 	[0xcb]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 204 	[0xcc]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 205 	[0xcd]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 206 	[0xce]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 207 	[0xcf]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 208 	[0xd0]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 209 	[0xd1]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 210 	[0xd2]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 211 	[0xd3]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 212 	[0xd4]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 213 	[0xd5]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 214 	[0xd6]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 215 	[0xd7]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 216 	[0xd8]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 217 	[0xd9]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 218 	[0xda]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 219 	[0xdb]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 220 	[0xdc]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 221 	[0xdd]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 222 	[0xde]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 223 	[0xdf]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 224 	[0xe0]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 225 	[0xe1]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 226 	[0xe2]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 227 	[0xe3]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 228 	[0xe4]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 229 	[0xe5]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 230 	[0xe6]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 231 	[0xe7]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 232 	[0xe8]
	0x04>>1,0x54>>1,0x50>>1,0x14>>1,0x44>>1,		// 233 	[0xe9]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 234 	[0xea]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 235 	[0xeb]
	0x10>>1,0x22>>1,0x10>>1,0x22>>1,0x10>>1,		// 236 	[0xec]
	0x10>>1,0x22>>1,0x20>>1,0x22>>1,0x10>>1,		// 237 	[0xed]
	0x20>>1,0x22>>1,0x20>>1,0x22>>1,0x20>>1,		// 238 	[0xee]
	0x40>>1,0x22>>1,0x20>>1,0x22>>1,0x40>>1,		// 239 	[0xef]
	0x10>>1,0x38>>1,0x7c>>1,0x10>>1,0x10>>1,		// 240 	[0xf0] arrow left
	0x10>>1,0x10>>1,0x7c>>1,0x38>>1,0x10>>1,		// 241 	[0xf1] arrow right
	0x10>>1,0x18>>1,0x7c>>1,0x18>>1,0x10>>1,		// 242 	[0xf2] arrow up
	0x10>>1,0x30>>1,0x7c>>1,0x30>>1,0x10>>1,		// 243 	[0xf3] arrow down
	0xf8>>1,0xe4>>1,0xf2>>1,0xfa>>1,0xfa>>1,		// 244 	[0xf4] folder left part
	0xf4>>1,0xf8>>1,0x78>>1,0x30>>1,0x10>>1,		// 245 	[0xf5] folder right part
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 246 	[0xf6]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 247 	[0xf7]
	0x00>>1,0x00>>1,0x00>>1,0x00>>1,0x00>>1,		// 248 	[0xf8]
	0xfe>>1,0x7b>>1,0xff>>1,0x7b>>1,0xfe>>1,		// 249 	[0xf9]
	0xfe>>1,0x7a>>1,0xfe>>1,0x7a>>1,0xfe>>1,		// 250 	[0xfa]
	0xfc>>1,0x78>>1,0xfc>>1,0x78>>1,0xfc>>1,		// 251 	[0xfb]
	0xf8>>1,0x78>>1,0xf8>>1,0x78>>1,0xf8>>1,		// 252 	[0xfc]
	0xf0>>1,0x70>>1,0xf0>>1,0x70>>1,0xf0>>1,		// 253 	[0xfd]
	0xe0>>1,0x60>>1,0xe0>>1,0x60>>1,0xe0>>1,		// 254 	[0xfe]
	0xc0>>1,0x40>>1,0xc0>>1,0x40>>1,0xc0>>1			// 255 	[0xff]
};
*/

